var networking = {

  // A little strategy here - we'd like to open one port to send and receive on, but in case we
  // can't get port 4000 for listening we still want to be able to send messages to the device

  NoAddressException: "No Address",
  NoPortException: "No Port",
  NotConnectedException: "Not Connected",

  socket: null,
  // If socket created this will be valid
  socketInfo: null,
  remoteAddress: "", 
  remotePort: 0,
  // Address to listen on
  localAddress: "0.0.0.0",
  localPort: 0,

  // Indicates port has been bound for incoming datagrams
  connectedReceive: false,
  connectedTransmit: false,

  // Receive callbacks
  callbacks: [],
  
  // Networking Constructor
  initialize: function(deviceIp, initializedCallback, receiveCallback) {
    console.log("Initializing");
	/*
    // Wait until here to set socket, otherwise it won't have been loaded yet
    this.socket = chrome.sockets.udp;
    // Attempt to bind to local port 4000
    this.connect(deviceIp, 4000, 4000, function(receiveStatus, transmitStatus) {
      //navigator.notification.alert("Connected receive=" + receiveStatus + ", transmit=" + transmitStatus, null, "Init", "OK");
      console.log("Networking initialized and bound");
      if (initializedCallback !== "undefined" && initializedCallback != null) {
        initializedCallback(receiveStatus, transmitStatus);
      }
      //navigator.notification.alert("Connected to device", null, "Init", "OK");
      if (receiveCallback !== "undefined" && receiveCallback != null) {
        this.receive(receiveCallback);
      }
    }.bind(this));
	*/
	
  },
  deinitialize: function() {
	/*
    this.socket.close(this.socketInfo.socketId, function() {
    // Socket is now guaranteed to be closed
      this.socketInfo = null;
    }.bind(this));
	*/
  },
  isReadyToInitialize: function() {
    // Assume we're ready to init if socketInfo is null
    return (this.socketInfo === null);
  },
  connect: function(inRemoteAddress, inRemotePort, inLocalPort, callback) {
    if (!!inRemoteAddress == false) throw NoAddressException;
    if (!!inRemotePort == false) throw NoPortException;
    if (!!inLocalPort == false) throw NoPortException;

    this.remoteAddress = inRemoteAddress;
    this.remotePort= inRemotePort;  
    this.localPort = inLocalPort;

    if (typeof this.socket !== 'undefined') {
      console.log("Creating socket");
      //navigator.notification.alert("Creating socket", null, "Init", "OK");
      this.socket.create({}, function(_socketInfo) {
        this.socketInfo = _socketInfo;
        //navigator.notification.alert("Socket created " + this.socketInfo.socketId, null, "Init", "OK");
        // Bind to all local interfaces on the provided local port
        this.socket.bind(this.socketInfo.socketId, this.localAddress, this.localPort, function(connectResult) {
          console.log("Connect result for port " + this.localPort + " = " + connectResult);
          //navigator.notification.alert("Connect result for port " + this.localPort + " = " + connectResult, null, "Init", "OK");
          this.connectedReceive = (connectResult >= 0);
          if (!this.connectedReceive) {
            // We weren't able to bind to the provided port, try using a local port of 0 to auto assign
            console.log("Unable to bind to port, attempting auto assign");
            //navigator.notification.alert("Unable to bind to port, attempting auto assign", null, "Init", "OK");
            this.localPort = 0;
            this.socket.bind(this.socketInfo.socketId, this.localAddress, this.localPort, function(connectResult) {
              console.log("Connect result for port " + this.localPort + " = " + connectResult);
              // We are wired to transmit only (auto assigned local port)
              // Don't add the listener
              this.connectedTransmit = (connectResult >= 0);
              callback(this.connectedReceive, this.connectedTransmit);
            }.bind(this));
          } else {
            // We are wired to transmit and receive on the selected local port
            this.connectedTransmit = true;
            // Setup the receive listener
            this.socket.onReceive.addListener(this.receiveListener.bind(this));
            // Let folks know we're connected
            callback(this.connectedReceive, this.connectedTransmit);
          }
        }.bind(this));
      }.bind(this));
    } else {
      console.log("Not creating socket");
    }
  },
  stringToArrayBuffer: function(string) {
    var buffer = new ArrayBuffer(string.length);
    var bufView = new Uint8Array(buffer);
    for (var i=0; i < string.length; i++) {
      bufView[i] = string.charCodeAt(i);
    }
    return buffer;
  },
  // Data received
  receiveListener: function(result) {
    // Call all our stored callbacks
    //console.log("Received data on " + result.socketId + " from " + result.remoteAddress + ":" + result.remotePort + ". " + this.callbacks.length + " callbacks");
    for (var i=0; i < this.callbacks.length; i++) {
      this.callbacks[i](result);
    }
  },
  arrayBufferToString: function(bufer) {
    return String.fromCharCode.apply(null, new Uint8Array(buffer));
  },
  send: function(data, callback) {
    callback = callback || function() {};
    if (!this.connectedTransmit) throw this.NotConnectedException;
    this.socket.send(this.socketInfo.socketId, data, this.remoteAddress, this.remotePort, function(sendResult) {
      callback(sendResult);
    }.bind(this));
  },
  sendString: function(stringData, callback) {
    var sendBuffer = this.stringToArrayBuffer(stringData);
    this.send(sendBuffer, callback);
  },
  receive: function(callback) {
    if (this.connectedReceive == false) throw this.NotConnectedException;
    this.callbacks.push(callback);
  },
  disconnect: function() {
    if (this.socketInfo !== null) throw this.NotConnectedException;
    this.socket.close(this.socketInfo.socketId, function() {
      this.connected = false;
    }.bind(this));
  }
};
